#!/bin/sh
#
# THE BEER-WARE LICENSE 2012
# <as@paefchen.net> wrote this file. As long as you retain this notice you
# can do whatever you want with this stuff. If we meet some day, and you think
# this stuff is worth it, you can buy me a beer in return Aron Schlesinger
#
# $Paefchen: scripts/pgallery/src/pgallery.sh,v 1.9 2012/08/28 17:37:11 as Exp $
#

ARG_TITLE="PGallery"
ARG_FILES=
ARG_FILETYPES="jpg jpeg png gif tif tiff"
ARG_TNSIZE="180"
ARG_TNQALITY="70"
ARG_BIGSIZE="950"
ARG_BIGQALITY="90"
ARG_INDEX="index.html"
ARG_DIR="."
ARG_UPDATE=1
ARG_COPYRIGHT="&copy; $(date +%Y)"
ARG_INFOFILE=""
ARG_MAILTO=""
ARG_MAILFROM="PGallery <${USER}@${HOST}>"
ARG_URL=
ARG_EXIF="0x920a 0x829d 0x829a ISO 0x8827 / 0x010f - 0x0110"

BIN_CONVERT="/usr/local/bin/convert"
BIN_EXIFAUTOTRAN="/usr/local/bin/exifautotran"
BIN_IMGINFO="/usr/local/bin/imginfo"
BIN_SENDMAIL="/usr/sbin/sendmail"
BIN_EXIFTRAN="/usr/local/bin/exiftran"
BIN_EXIF="/usr/local/bin/exif"

MKAKEFILE=".htmakefile"
VERSION="pgallery-1.2"

#
# usage()
#
usage()
{
	cat <<USAGE
usage $0: ( [-f <files>] | [-s <suffix>] ) [-d <dir>] [-n <name>]
                [-t <thumbnail_size>] [-u <thumbnail_quality>]
                [-b <big_size>] [-c <big_quality>] [-l link] [-e <exif>]
                [-i <index>] [-C <copyright>] [-F <mailfrom>] [-T <mailto>]
                [-U] | -h | -v
Options:
  -b size       size from big images in pixel (default: $ARG_BIGSIZE)
  -c quality    quality from big images 0-100% (default: $ARG_BIGQALITY)
  -d dir        gallery dir (default: $ARG_DIR)
  -e exif       list of tags in hex. (default: $ARG_EXIF)
                see: http://www.exiv2.org/tags.html
  -f files      gallery images
  -h            this page
  -i name       index file name (default: $ARG_INDEX)
  -l url        gallery link
  -n name       page title (default: $ARG_TITLE)
  -s suffix     list of suffix. if no \`\`-f'' defined, used to find images
                in \`\`-d'' directoy. case insensitive
                (default: $ARG_FILETYPES)
  -t size       size from thumbnail images in pixel (default: $ARG_TNSIZE)
  -u quality    quality from thumbnail images 0-100% (default: $ARG_BIGQALITY)
  -v            print version
  -C copyright  copyright (html) string (default: $ARG_COPYRIGHT)
  -F from       mail sender (default: $ARG_MAILFROM)
  -I file       info text file for pgallery. info file paras prefered.
                the syntax of the file is MAKE(1)
                supported variable: TITLE COPYRIGHT INDEX FILETYPES TNSIZE URL
                                    TNQALITY BIGSIZE BIGQALITY MAILTO MAILFROM
                                    EXIF
  -T mailto     send update infos to this address. if not set, no mail delivery
  -U            no update, new calculation of all images.
                normally only new and modified images will calculated
USAGE
	exit
}

#
# get_my_path()
#
get_my_path()
{
	current=$(pwd)
	cd $(dirname $0)
	echo $(pwd)/$(basename $0)
	cd "$current"
}

#
# html_header()
#
html_header()
{
	cat <<HTML
<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN"
"http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
<html xmlns="http://www.w3.org/1999/xhtml">
<head>
	<title>$ARG_TITLE</title>
		<meta http-equiv="Content-Type" content="text/html; charset=ISO-8859-1" />
		<style type="text/css">
		<!--
body {
	background-color: #464646;
	background-image: url("data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAAFgAAABYB\
AMAAACDuy0HAAAAG1BMVEX+/v4BAQH///8KCgoDAwN/f3/19fWAgID8/PzhDwT2AAAACXRSTlMFBQUFBQU\
FBQWHDtP9AAALwklEQVR4Xg3KOWOyWhAA0Bn2ci57eXEvQY1JCZp8sQTjVoJLTAkaE0swbj/7ve4UB37FL\
W4q86Lwwlh86J/ASAkpWaj+Krbb31HzH0Kjc2tIl7SADaWbpZBPE5dds6jJNyNdjAyKWqdroIixWRQIY6E\
/kOY7hIciL/ZfrAO3XP/06AuUJ3mSd/z95OB9vIal0DPlaZWHP7RE6DIXjmKqKkuGr+xNZylOnj1GSlUKv\
nxZDBOIzTfMe0fJgJ7c/GIIOdUuKxYyBFUOzvY6AC5AXx8R+o5O4S0j0wqBND3ErIYm/XHFbQjtH1MXD5d\
Ubp19OFdjkDlys+HSwrBgHRvL9wVN/pi8ViOIwcv/D1GRW6UuDvJLLQA5lCI17iUdsKYpOuYfMATGnpn/Z\
s3W6gov51G+/Vs9Ay//we5kh8uwvEPum6o5HkDMDb3ZWunwtq+UzENU8NphDdbvNtKM3knx5gi6UMSQl+e\
Gs+27mraDtxeWdH+T62Us/GylEtr7Ct8jlbeXKvAf5onx8D2uVt1J/GblV+XQyKUInOUG44fqjcszK266y\
HWAAYG9ekhvy4l4Maa44jYVyV2RFEuS54e2HcswtmNdqR/+V4P0O9e4XnpWgxVSQkNXpYMCxJ4Vel0lmi5\
6jnYIIJAQMndF+zTEiyuj92r3ijJT1O0alPQnLWJvJLR7Xx7Xg9fm9QOqFu8o29m3QQqFwZN4bki/RoprN\
tMKKtEET9iMsJyKpkiguAorn2yzkv0wG3M1EEVDJP5VN7muLjYCglzdGQ7boYGgRmorzhRDq83gglgylC+\
hBLEyy6ZQWNwCmmqt6PvExAqGEA9V2XIT4/fS+I2cx1n5td85kOCjHfPWTg72FJ/+vKOyggt+rytFbEDJW\
L+mPwpgw6HtFLIHmq4o2m1nZ9saKwiKEOTVZtWlnqHODPu949VfKD+zzpfynd/ZZU5IWZ0dgnqRHC4uOBp\
BsT8N7YbFJzADiW2eo/T979OKFxY8zk/+HR/NNEkzgSBsmA35Sayz1m/ubxgmYQOmffyRh9gdx42mUVX51\
2oqWkfxAzyuSCxx1cywx3jIXuXJEEbssymo0xMy7SskJW9C5IPYroPwQunt7f5FEPPXJLWRbGHcL4Q3sx3\
TLAN6W672r/I5CKkL6zSwwk0AI8+iBCSv1Y7QQP5RSoLE227uy8vn22Y6dhLBgEsRh18cTGjIv3y+60Kmt\
3YAZQX8qf3bJDUc/5pdjti+KwAZ9GzzQzd23d1JBAnSvWkWB8YfsIGlspHitNiMPYPFfR+OecRuPyxgfoP\
9/HkR3cR27IohiaDXCk/3VNP6lIxP9TBnsMeAAUZloq6P8KURLBsNFuiA3LsN/d9qpCeKKIBgSzsN5k+rd\
h3uh0VbvMuOIomJD1fBOiCqIsvklS5bOQhMaahJC+Rc+6lz+Uvxmq05Py+LoGIQlLKvlcaHsFG9Ui66H/q\
dHz67sPRGho+ruC92QgN5JEMmLsZREEiJu78FJbyzT8FsdK90XoEcezn2R5iLUzZhczJmf1yNY3gJNJUQv\
bpTznTAbnV5J8iL4q2OWuhJEndWVTyEr8M5VGTWtvOmUo1DsnOsqXE5ZzKE8K4/8cl8+c1XArp1RUKz+iK\
P96j2FcUmA+v0HnEr0iUdSrRK5duAj1FQamvpiaXR2JddD6g8n4SyFx/fjT4LkC+ghJckj1e1wP+DrHrpI\
iMaPH5F1rcaRvwZWfEn6fx+/C7PdXABGLNKjr1USZ5XyHjsafXMEoXtguAfjykMioMMHISXVAc9yQY5o5Q\
g8MM0nhWCA2HoiEgBc1EH+warLjxH3Ln68M/ciFqI1bG0mBOxiNreOuShEf/9pIzhm1Bh2cbYVxn2IYQ7e\
ljYpab/5EdPF2PSmcy+62j6e2HBPNbe+8JVMuRQBrWdL9uBh4bYbQaQJ07FyfcpCuvSuxUyYjP6avvw9gT\
cAj0uTVohSwOHDDaHTs8nyachMBcWoVDWp3/lWgqeCLMneAUhSuhD2RJpufLOSi7emxOVhYsOGomV2JCEK\
jWu7kuqwueyFEmDgVhR0l4oHn8W87UZuxb8id54SxHWiSnPKnMyAhzdhi2wN/AoH3OYwLajuybB8h/QeJJ\
iX1gIt+dfij+gr0CJRXQ2Y04Q6q8xHzfWm9FIgchiW0+X86tIotIGzRG1gENaKokQkLn+FXZ2x3KUcp7d/\
NUsmOmFCG/i03YB8pi0eiNS4LUIfA06AKvfQmP/VAXS1AP2kzJ+9LAaTafvFyO7bz8U9OCpld2q1eHGts+\
ZFrt04AmIlubOPP7Xayfi/r0tiX2aaPT9Dz4+TVPBoXsjHDzWfrmawOsZfmBT/k2+c6sz/hvD5wjrjT7Xg\
RlnEzPuZermi1jqfUrE3q7VdFfJu5oT9Ad+VUh1fIwIFhBy8TmMuhIeX2XpmogmvS1C3ZuwiyR87ZSrj0J\
v1DpEAYkbcL3RpjZXmZpPV4mXH8z8Nh8CS+R+PpcTnkhyr5UJaSiz0wjK22Ewl+zS+pTug0PQ0CSnJQ5Lf\
dR77vVZufgjkQ/ydf4V5zpEaNq+JZmrQK6WdZBacmMHL9RmLnPUs0/MYwYFzoyrXYQMTHGAUJOfumR5r79\
MZO28DIEXQVT5wGw99TY1T0GOCC/BzWv8READwICd0LjUNKnE6ORVa0lOnqhoO0v33lwWcwF0ynTgTpFxy\
+0OKdphNDWJlH8ubKoG6WJXtKxAwbsilpBJB+GBwimvTsCrv1R7LSX9ExkAw44ZEcxU3L50OHnKAyKZNe1\
fih+hVqItRGCDf7shuvme+lTWteX5oYuc58NrCaqjYIrIV0PFyQeh2ZzZEqNS60LuhnP5wweMkkaU93pDA\
/RWPNeGpPCBgiUeDvV0L1NfdRP/Hn5i7rUK7kftlIWeIUIYbtzzFl9nlIeaNfoX+x/qyWzIABLTZDbeq/h\
DZpxg2gkh+ICfSU8OUpJ8yWY17uQ5EGa+GGWFmnrBd9vX3KOteYkJaMpPwJ4TjzDjbhkOMKmWKClzVJ2g8\
1YGFl/c0xPIKncgJGdUKvZoUUJu0gYaIAh6E0xNeQ15qpJXzNITgf4W+w/oUaKOM54EMUi1j5yvOCsEe8J\
YpwVGj53lNiPMY9Rltgd4icp82fvN69zkSBUI40nJSRTeHz7h1IX42Cr0klWjxjO05MSX1IaTeDmTRGEeK\
vAvtaaBaLQnjftGJz+4cjFyy6/iCjLGF2/gW+jQhEUxbEBPyQzXi+Bb4kc9wK4jIwNLWbwQAOtYKRLaipD\
H+X4TPPOG8DCNY4IC9yBk1qcibjhUgRnDcf35pl9d5otbvQjOIXlEu5dVtm5LRaK5KWcD/PX6LaGd25CuN\
HG/vgeIB1kcpCme+J8idlcjfBALAJSggznsGHGOAJgdGduMnZg+bAaeGASGV9bh/X2wPsVTmBLxmTTQsBG\
FkEOkZJTsGAm+HrtMDbWwvTXOutX1u7BxIq9Xib6DkFMbUitNdrYsULkahsAhBEh9FjdzL9BNARxTSr7T3\
u1rE+IWUmCIpwTZHZCu5l9THCuCcOhZqfekuQxjQ7EoyGUJAwCv/q1JOuJeCc/3lknb76zAquO/DAQhK/6\
2cP8X2s3+IBLIhvL8RHopoHpIArJysYTTmMMeubPXh8W760AvMVH67jqgg06+/ne5MZ631z6yROhloh3dP\
QirZoEpr80wgt/cEbhbAQTmRLtGh8lxCwDBBb5OeJ4aEq25XBNMT2rzWedW2zIzj+CCDKlnlyJBzT81qBW\
p69h7vlb3TmEV+DNm2rqj1iT7BQuwVVsuPkwq1e5P8tgNjVbIlMzwXeM11kZqjx3KKFOJzc3CAyFVhi8fx\
VZ5FvhdAM5mM6kS6OgKu16MFglq3/b/QVIwdw7HUCyeW04JPjC5dO+GC9OfqfB4VX+wwuift+ths2Ss3i6\
nkOE+JFyD+wKFL+WMX6nwwDva0S1/O8Mlnida69Ph96fuFvCoRMvXnCfsLPPmC/hA5RnMNE4fDK0pVOQ4B\
HLaErzv/wD99ABmjNZk0AAAAABJRU5ErkJggg==");
	margin: 10px auto;
	font-family: Geneva,Arial,sans-serif;
	font-size: 12px;
	text-shadow: 1px 1px 1px #000;
	color: #808080;
}
div.tn {
	float: left;
	width: ${ARG_TNSIZE}px;
	height: ${ARG_TNSIZE}px;
	vertical-align:text-top;
	text-align: center;
	margin: 4px;
}
div.tn a {
	position: relative;
	display: inline-block;
	height: ${ARG_TNSIZE}px;
}
div.tn, div.big {
	background-color: black;
	border-width: 1px;
	border-style: solid;
	border-color: gray;
	box-shadow: 1px 1px 2px #000;
	padding: 1px;
	border-radius: 3px;
}
div.tn:hover {
	background-color: #222;
}
div.big {
	display: inline-block;
	width: ${ARG_BIGSIZE}px;
}
div.over {
	width: ${ARG_BIGSIZE}px;
	position: absolute;
	top: 30px;
	padding: 1px;
}
div.over a.left, div.over a.right {
	display: block;
	/* shell fuck of: missing CTLARI (shouldn't happen) - WTF?! */
	width: $(($ARG_BIGSIZE / 2))px;
	position: relative;
	top: 1px;
	left: 1px;
	background-repeat: no-repeat;
}
div.over a.left:hover {
	background-position: 5% center;
	background-image: url("data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAAB0AAAAwC\
AYAAADtoXHnAAAAGXRFWHRTb2Z0d2FyZQBBZG9iZSBJbWFnZVJlYWR5ccllPAAAAh9JREFUeNrE2L1Lw0A\
UAHATSivSZii0ldpBnMU6SgYJpQUJDlk7dLV+LTqIiIv4B7kLolBKQRA6GLqUDMEhqKAlhUIR4125SHo0b\
XJ51x68pDSX+3G5I/dyguM4S/MuMfeHIAiQ7Yo+//+OocAYPm+jWEXxg8JC8erCgvt4AXrqgkkUJRRZ6jq\
G71EMRcAeil6wWq2uGYZx1ul0jjRNy5Jey6PauKcRJ5NIhklCoaE4QODNYDCwHVJ6vd5HIpE4xNdQxKOiM\
0G3FIvFc4Imo6CBQV3XXwioje5jREOBkiQdE3SLFWUFFXJfaJQVLP2DIWdvFDA+9pYKiMKBAVFYMAAKD85\
A+YBTUH6gD8oXnIDyB31QviCFzgekUPxYVe4ghW7ixhRFueQKUmgZN9hut1s0aNv2V6FQOAUBqRvT+IAaX\
6crWZb1hsqQJFfPkPnpJz6YpmnQlXK5XD6TycRIcrUDib7jQ71ev+v3+9/eSqlUKt1qtU4IvIFid2x9jDC\
muJE9PG6qql7jcaTHttvt6gh2J1MZYva6ees+d9jnjcQXnoDyh31WGb7wlPWUHzwjc+ADB8iR4OGA2SAsH\
CLvhYNDZvgwMMO3THSY8auNBS6xfrVFhZUoaGjYk+qA7DkEgmu12i1Bs1C7K1NhvLviecTLEOhEuFKpXDW\
bzcdGo/Egy/KFZzKJPHbMVsiEyVPXTRRPeMdMWMQuqLi0gPInwACOBcZx3lRFMwAAAABJRU5ErkJggg==");
}
div.over a.right:hover {
	background-position: 95% center;
	background-image: url("data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAAB0AAAAwC\
AYAAADtoXHnAAAAGXRFWHRTb2Z0d2FyZQBBZG9iZSBJbWFnZVJlYWR5ccllPAAAAiJJREFUeNrE2D1Lw0A\
YAOAmlNbBdii0FVM6OEu7SgcJpRUJDlk7dE21uuggIi7iD/IX+AGlFAXBDqVLyVCCBBW0JFhwMN7JHRxnY\
5PcnX3hhSM58nB3+Xhzkud5sf8OiWjLPn2+eGF4gHEChLkOcgUdt0E+isAlhCVAbiGQjGeQ1yBdHjAeKZ7\
SCgR1Xc8Nh8M90zQPG42GAo7lQFZBLhOzwSXgKI1kMrk7mUxePBTT6dQB8Dk8B1IHmUbTLrOMFI8WjsIol\
8tHHhW8YRKV0QWNwWDwIBKm0RK8aDqdbouEaRReQBUNkygJV0XCNBojnldh8CxUOOyHCoX/QoXB81AhcBC\
UOxwU5QqHQbnBYVFWODLKDEdFo8IanGYWNBSsquoJgkus6C+4UCgcOI7zRsP9fv8OoTWM8qh57mHlaFnWp\
23bFn1SUZQiambm1bphYgMWddlsNp7P51fpk+Px2ETNV1YUf383Qa5BsNfr7adSqQzZyXXd91ardUmUs8x\
rWYNrBcD2aDQa0GsJ11fTtDO0ntssd28UcAfXzSxvpLBg5DcSKyhH/cowgVG+p8xg2MqBCximRuIGBq0Gu\
YJB6l7u4LwKXwjo9y8jFPT7a6uKBGehqmiQRhO45BAJ0ijcQTGazeaFSJBGl/DUkrsrvMFZa/pzE1UqleN\
Op3PV7XZv6vX6KU+QRMkdM3gzFal+TyBvQX7w3DGTFrELKscWEN8CDADBm8pgcciwqgAAAABJRU5ErkJgg\
g=="); 
}
div.big a {
	position: relative;
	display: inline-block;
	width: ${ARG_BIGSIZE}px;
}
div.box {
	text-align: center;
	width: ${ARG_BIGSIZE}px;
	margin: auto;
}
div.box div.d {
	width: ${ARG_BIGSIZE}px;
	padding: 5px;
	text-align: center;
}
div.box div.i {
	width: ${ARG_BIGSIZE}px;
	font-size: 90%;
	height: 25px;
	line-height: 25px;
	position: relative;
	left: 4px;
}
body > div.c {
	text-align: center;
	font-size: 90%;
	height: 25px;
	line-height: 25px;
	position: relative;
	margin: 4px;
}
a img {
	border-width: 0;
}
a {
}
div.nav {
	width: ${ARG_BIGSIZE}px;
	height: 20px;
}
div.nav a {
	color: #FFF;
	text-decoration: none;
}
div.nav a:hover {
	text-decoration: underline;
}
div.nav div.top {
	position: absolute;
	text-align: center;
	width: $(($ARG_BIGSIZE - 100))px;
	margin: 0 50px;
}
.left {
	float: left;
}
.right {
	float: right;
}
.clear {
	clear: both;
}
		-->
		</style>
	</head>
<body>
HTML
}

#
# html_footer()
#
html_footer()
{
	cat <<HTML
</body></html>
HTML
}

#
# html_tn()
#
html_tn()
{
	tn=$1
	link=$2

	info=$($BIN_IMGINFO -f $tn)
	width=$(echo $info | awk '{print $3}')
	height=$(echo $info | awk '{print $4}')
	top=$(($(($ARG_TNSIZE - $height)) / 2))

	cat <<HTML
<div class="tn">
	<a href="$link" style="top:${top}px">
		<img alt="$tn" width="$width" height="$height" src="$tn" />
	</a>
</div>
HTML
}

#
# html_img()
#
html_img()
{
	orig=$1
	img=$2
	link=$3
	linkb=$4
	linkn=$5

	info=$($BIN_IMGINFO -f $img)
	width=$(echo $info | awk '{print $3}')
	height=$(echo $info | awk '{print $4}')

	desc=$(get_exif_desc $orig)
	if [ "$desc" != "" ]
	then
		desc="<div class='d'>$desc</div>"
	fi

	if [ "$linkb" != "" ]
	then
		hlinkb="<a href='$linkb'>zurck</a>"
		olinkb="<a class='left' style='height:${height}px' href='$linkb'></a>"
	fi

	if [ "$linkn" != "" ]
	then
		hlinkn="<a href="$linkn">weiter</a>"
		olinkn="<a class='right' style='height:${height}px' href='$linkn'></a>"
	fi

	cat <<HTML
<div class="box">
	<div class="nav">
		<div class="top"><a href="$link">Index</a></div>
		<div class="left">$hlinkb</div>
		<div class="right">$hlinkn</div>
	</div>
	<div class="big">
		<img alt="$img" width="$width" height="$height" src="$img" />
	</div>
	$desc
	<div class="i">
		<div class="left">$(get_exif_info $orig)</div>
		<div class="right">$ARG_TITLE $ARG_COPYRIGHT</div>
	</div>
	<div class="over" style='height:${height}px'>
		$olinkb
		$olinkn
	</div>
</div>
HTML
}

#
# err
#
err()
{
	echo "$1" >&2
	exit 1
}

#
# mysendmail()
#
mysendmail()
{
	subject=$1
	(
		cat <<MAIL
From: $ARG_MAILFROM
To: $ARG_MAILTO
Subject: $subject
Content-Type: text/plain; charset=iso-8859-1
X-Mailer: $VERSION

$(cat)
MAIL
	) | $BIN_SENDMAIL -t
}

#
# get_exif_desc()
#
get_exif_desc()
{
	img=$1
	$BIN_EXIF --ifd=0 --tag=0x010e -m $img 2> /dev/null | iconv -t ISO-8859-1 -f UTF-8 | while read line
	do
		echo "$line<br />"
	done
}

#
# get_exif_value()
#
get_exif_value()
{
	img=$1
	hex=$2
	$BIN_EXIFTRAN -d $img | grep $hex | sed -E 's/^.{45}//'
}

#
# get_exif_info()
#
get_exif_info()
{
	img=$1
	exifinfo=
	for exif in $ARG_EXIF
	do
		if echo $exif | grep -q -E '0x[[:alnum:]]{4}'
		then
			exifinfo="$exifinfo$(get_exif_value $img $exif) "
		else
			exifinfo="$exifinfo$exif "
		fi
	done
	echo $exifinfo | sed -e 's/ mm /mm /' -e 's/ sec./s/' -e 's/ ISO / ISO/'
}

# parse args
while [ "$1" != "" ]
do
	arg=$1
	shift
	case $arg in
		-h)
			usage;;
		-n)
			ARG_TITLE=$1
			shift;;
		-t)
			ARG_TNSIZE=$1
			shift;;
		-u)
			ARG_TNQALITY=$1
			shift;;
		-b)
			ARG_BIGSIZE=$1
			shift;;
		-c)
			ARG_BIGQALITY=$1
			shift;;
		-f)
			ARG_FILES=$1
			shift;;
		-l)
			ARG_URL=$1
			shift;;
		-s)
			ARG_FILETYPES=$1
			shift;;
		-d)
			ARG_DIR=$1
			shift;;
		-e)
			ARG_EXIF=$1
			shift;;
		-C)
			ARG_COPYRIGHT=$1
			shift;;
		-F)
			ARG_MAILFROM=$1
			shift;;
		-I)
			ARG_INFOFILE=$1
			shift;;
		-T)
			ARG_MAILTO=$1
			shift;;
		-U)
			ARG_UPDATE=0;;
		-v)
			echo $VERSION
			exit;;
		*)
			echo "unknown argument $arg"
			exit
	esac
done

# parese info file
if [ "$ARG_INFOFILE" != "" ]
then
	test -f $ARG_INFOFILE || err "info file not found \`\`$ARG_INFOFILE''"
	for n in TITLE COPYRIGHT INDEX FILETYPES TNSIZE TNQALITY BIGSIZE \
		BIGQALITY MAILTO MAILFROM URL EXIF
	do
		v=$(make -f $ARG_INFOFILE -V$n)
		test "$v" = "" && continue
		eval "ARG_$n='$v'"
	done	
fi

# go to gallery directory
MY=$(get_my_path)
cd "$ARG_DIR" || exit 1

# fix url
if [ "$ARG_URL" != "" ]
then
	echo "$ARG_URL" | grep -q '/$' || ARG_URL="${ARG_URL}/"
fi

# if no images defined, find files
if [ "$ARG_FILES" = "" -a "$ARG_FILETYPES" != "" ]
then
	match=
	for type in $ARG_FILETYPES
	do
		match="$match *.$(echo $type | tr '[:lower:]' '[:upper:]')"
		match="$match *.$(echo $type | tr '[:upper:]' '[:lower:]')"
	done
	ARG_FILES=$(cd $ARG_DIR && ls $match 2>/dev/null)
fi

# Filter big and thumbnails
echo -n "find images"
FLIST=
for file in $ARG_FILES
do
	test $(echo $file | grep -E '\.(tn|big)\.jpg$') && continue
	FLIST="$FLIST $file"
	echo -n " $file"
done
echo 

test $(echo $FLIST | wc -w) -eq 0 && err "error: no image found in \`\`$ARG_DIR''"

# find new and to update images
FLIST_NEW=
FLIST_UPDATE=
echo "all: tns" > $MKAKEFILE
targets=""
for file in $FLIST
do
	tn="${file}.tn.jpg"
	if [ ! -f $tn ]
	then
		FLIST_NEW="$FLIST_NEW $file"
		continue
	fi

	targets="$targets $tn"
	(
		cat <<MAKE
$tn: $file
	@echo ${file}
MAKE
	) >> $MKAKEFILE
done
echo "tns: $targets" >> $MKAKEFILE
FLIST_UPDATE=$(make -f $MKAKEFILE)
rm $MKAKEFILE

# update and no new and update images found
if [ $ARG_UPDATE -eq 1 -a "$FLIST_NEW" = "" -a "$FLIST_UPDATE" = "" ]
then
	echo nothing to do
	exit 1
fi

if [ $ARG_UPDATE -eq 1 ]
then
	echo new images: $FLIST_NEW
	echo update images: $FLIST_UPDATE
fi

# Create make file to rotate und convert all big and thumbnails.
# Is needed to define the new real image sizes.
echo "all: tns" > $MKAKEFILE
targets=""
for file in $FLIST
do
	tn="${file}.tn.jpg"
	big="${file}.big.jpg"
	targets="$targets $tn"

	target=
	if [ $ARG_UPDATE -eq 1 ]
	then
		target="$tn: $ME $file"
	else
		target="$tn::"
	fi

	(
		cat <<MAKE
$target
	$BIN_EXIFAUTOTRAN $file
	$BIN_CONVERT -verbose -thumbnail ${ARG_TNSIZE}x${ARG_TNSIZE} -quality $ARG_TNQALITY $file $tn
	$BIN_CONVERT -verbose -thumbnail ${ARG_BIGSIZE}x${ARG_BIGSIZE} -quality $ARG_BIGQALITY $file $big
MAKE
	) >> $MKAKEFILE
done
echo "tns: $targets" >> $MKAKEFILE

make -f $MKAKEFILE
rm $MKAKEFILE

# create single html files
index=""
i=0
echo -n "create single html files "
for file in $FLIST
do
	h=$i
	i=$(($i + 1))
	j=$(($i + 1))

	tn="${file}.tn.jpg"
	big="${file}.big.jpg"
	imglink="${file}.html"

	if [ $i -ne 1 ]
	then
		linkb=$(echo $FLIST | awk "{print \$$h}").html
	fi
	linkn=$(echo $FLIST | awk "{print \$$j}")
	test "$linkn" != "" && linkn="$linkn.html"

	echo -n .
	index="$index $(html_tn $tn $imglink)"
	(
		html_header
		html_img $file $big $ARG_INDEX "$linkb" "$linkn"
		html_footer
	) > $imglink
done
echo

# create html index
echo create html index
(
	html_header
	echo $index
	echo "<div class='clear'></div>"
	echo "<div class='c'>$ARG_TITLE $ARG_COPYRIGHT</div>"
	html_footer
) > $ARG_INDEX


test "$ARG_MAILTO" = "" && exit 0

# send info mail
if [ "$FLIST_NEW" != "" -o "$FLIST_UPDATE" != "" ]
then
	echo "send mail to $ARG_MAILTO"
	(
		echo "Hallo,"
		echo
		echo -n "the gallery $ARG_TITLE has been updated"
		if [ "$ARG_URL" != "" ]
		then
			echo ":"
			echo $ARG_URL
		else
			echo "."
		fi

		suffix=
		test "$ARG_URL" != "" && suffix=.html

		if [ "$FLIST_NEW" != "" ]
		then
			echo
			echo "add pictures:"
			for file in $FLIST_NEW
			do
				echo "- ${ARG_URL}${file}${suffix}"
			done
		fi

		if [ "$FLIST_UPDATE" != "" ]
		then
			echo
			echo "update pictures:"
			for file in $FLIST_UPDATE
			do
				echo "- ${ARG_URL}${file}${suffix}"
			done
		fi
	) | mysendmail "PGallery Update: $ARG_TITLE"
fi
